# -*- coding: utf-8 -*-

from distutils.core import setup

# Python 2/3 installation trick from .../Demo/distutils/test2to3
try:
    from distutils.command.build_py import build_py_2to3 as build_py
except ImportError:
    from distutils.command.build_py import build_py

try:
    from distutils.command.build_scripts import build_scripts_2to3 as build_scripts
except ImportError:
    from distutils.command.build_scripts import build_scripts

# Version
VERSION = "1.5"
if "#" in VERSION:
    import sys
    sys.stderr.write("Bad version %s\n" % VERSION)
    sys.exit(1)


setup(name         = "nodes",
      version      = VERSION,
      description  = "Handle hierarchical groups of nodes",
      long_description = "Handle hierarchical groups of nodes, such as enclosures and racks.",
      author       = "Kent Engström",
      author_email = "kent@nsc.liu.se",
      url          = "http://www.nsc.liu.se/~kent/nodes/",
      license      = "GPL2+",
      classifiers  = ['Development Status :: 4 - Beta',
                      'Intended Audience :: Science/Research',
                      'Intended Audience :: System Administrators',
                      'License :: OSI Approved :: GNU General Public License (GPL)',
                      'Topic :: System :: Clustering',
                      'Topic :: System :: Systems Administration',
                      'Programming Language :: Python :: 2',
                      'Programming Language :: Python :: 3',
                      ],
      py_modules   = ["nodes"],
      scripts      = ["nodes"],
      data_files   = [("/etc", ["nodes.conf"]),
                      ("share/man/man1", ["nodes.1"]),
                      ("share/man/man5", ["nodes.conf.5"]),
                      ],
      cmdclass     = {'build_py':build_py,
                      'build_scripts':build_scripts,
                      }
      )
